/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.seppiko.commons.utils.RegexUtil;
import org.seppiko.commons.utils.reflect.TypeUtil;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <K, V> Map<K, V> populateMap(Collection<? extends V> elements, Function<? super V, ? extends K> keyFunction) {
        return CollectionUtil.populateMap(elements, keyFunction, Function.identity());
    }

    public static <E, K, V> Map<K, V> populateMap(Collection<? extends E> elements, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> valueFunction) {
        return elements.stream().collect(Collectors.toMap(keyFunction, valueFunction, (key1, key2) -> key2));
    }

    public static <K, V> Map<K, V> populateMapWithoutFilter(Collection<? extends V> elements, Function<? super V, ? extends K> keyFunction) {
        return CollectionUtil.populateMapWithoutFilter(elements, keyFunction, Function.identity());
    }

    public static <E, K, V> Map<K, V> populateMapWithoutFilter(Collection<? extends E> elements, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> valueFunction) throws IllegalStateException {
        return elements.stream().collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static <E, T> List<T> populateList(Collection<? extends E> elements, Function<? super E, ? extends T> valueFunction) {
        return elements.stream().map(valueFunction).collect(Collectors.toList());
    }

    public static <E, T> Set<T> populateSet(Collection<? extends E> elements, Function<? super E, ? extends T> valueFunction) {
        return elements.stream().map(valueFunction).collect(Collectors.toSet());
    }

    public static <T, C extends Collection<T>> Collection<T> clone(Collection<? extends T> collection, Supplier<C> supplier) {
        return (Collection)collection.stream().collect(Collectors.toCollection(supplier));
    }

    public static <E> String toString(Collection<E> elements, Function<? super E, String> elementFunction, CharSequence delimiter) {
        return CollectionUtil.toString(elements, elementFunction, delimiter, (CharSequence)"", (CharSequence)"");
    }

    public static <E> String toString(Collection<E> elements, Function<? super E, String> elementFunction, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return elements.stream().map(elementFunction).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static <K, V> String toString(Map<K, V> map, Function<? super K, String> keyFunction, Function<V, Object> valueFunction, CharSequence follower, CharSequence delimiter) {
        return CollectionUtil.toString(map, keyFunction, valueFunction, follower, delimiter, "", "");
    }

    public static <K, V> String toString(Map<K, V> map, Function<? super K, String> keyFunction, Function<V, Object> valueFunction, CharSequence follower, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return map.keySet().stream().map(k -> (String)keyFunction.apply((Object)k) + String.valueOf(follower) + valueFunction.apply(map.get(k)).toString()).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static <T> void swap(List<T> list, int a, int b) {
        T tmp = list.get(a);
        list.set(a, list.get(b));
        list.set(b, tmp);
    }

    public static <K, V> void fromString(Map<K, V> map, String str, String follower, String delimiter, Class<K> keyType, Class<V> valueType) throws NullPointerException, IllegalArgumentException {
        if (null == map || null == str) {
            throw new NullPointerException();
        }
        if (str.contains(delimiter)) {
            String[] pairs;
            for (String pair : pairs = RegexUtil.split(delimiter, str)) {
                CollectionUtil.parsePair(map, pair, follower, keyType, valueType);
            }
        } else {
            CollectionUtil.parsePair(map, str, follower, keyType, valueType);
        }
    }

    private static <K, V> void parsePair(Map<K, V> map, String pair, String follower, Class<K> keyType, Class<V> valueType) throws IllegalArgumentException {
        String[] keyValue = RegexUtil.split(follower, pair);
        K key = TypeUtil.fromObject(keyValue[0], keyType);
        V value = TypeUtil.fromObject(keyValue[1], valueType);
        if (map.containsKey(key)) {
            V oldValue = map.get(key);
            throw new IllegalArgumentException("Key " + key.toString() + " already contains old value " + oldValue.toString() + " .");
        }
        map.put(key, value);
    }

    public static <T> T[] toArray(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>(0);
        }
        return list.toArray(Object[]::new);
    }

    public static <T> T[] toArray(Set<T> set) {
        if (set == null) {
            set = new HashSet<T>(0);
        }
        return set.toArray(Object[]::new);
    }
}

