/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.seppiko.commons.utils.Environment;

public class IOStreamUtil {
    private IOStreamUtil() {
    }

    public static InputStream findFileInputStream(Class<?> clazz, String pathname) {
        try {
            return new FileInputStream(IOStreamUtil.findFile(clazz, pathname));
        }
        catch (IOException | NullPointerException exception) {
            return null;
        }
    }

    public static File findFile(Class<?> clazz, String pathname) throws NullPointerException {
        Objects.requireNonNull(pathname);
        String _pathname = IOStreamUtil.getClassLoaderPath(clazz.getClassLoader(), pathname);
        _pathname = _pathname == null ? pathname : _pathname;
        return new File(_pathname);
    }

    private static String getClassLoaderPath(ClassLoader cl, String path) throws NullPointerException {
        URL url = cl.getResource(path);
        return Objects.isNull(url) ? null : url.getPath();
    }

    public static File loadFile(String path) throws IllegalArgumentException, NullPointerException, IOException {
        String targetPath;
        File folder;
        File file = new File(path);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Target path is not a valid file.");
        }
        if (file.exists()) {
            return file;
        }
        String absolutePath = file.getAbsolutePath();
        int _lastFolder = absolutePath.lastIndexOf(47);
        if (_lastFolder < 0) {
            _lastFolder = absolutePath.lastIndexOf(92);
        }
        if (!(folder = new File(targetPath = absolutePath.substring(0, _lastFolder))).mkdirs()) {
            throw new IOException("Failed to create destination folder.");
        }
        if (!file.createNewFile()) {
            throw new IllegalArgumentException("Unable to load target file.");
        }
        return file;
    }

    public static InputStream getStream(Class<?> clazz, String pathname) {
        return IOStreamUtil.getStream(IOStreamUtil.findFile(clazz, pathname));
    }

    public static InputStream getStream(String filepath) {
        return IOStreamUtil.getStream(new File(filepath));
    }

    public static InputStream getStream(File file) {
        try {
            Objects.requireNonNull(file);
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException | NullPointerException exception) {
            return null;
        }
    }

    public static BufferedReader loadReader(String str) {
        return new BufferedReader(new StringReader(str));
    }

    public static BufferedReader loadReader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is));
    }

    public static BufferedReader loadReader(InputStream is, Charset charset) {
        return new BufferedReader(new InputStreamReader(is, charset));
    }

    public static void exportOutputStream(byte[] bytes, OutputStream os) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(os);){
            bos.write(bytes);
            bos.flush();
        }
    }

    public static String readerTo(BufferedReader reader, boolean lineStrip, boolean ignoreNewLine) throws IOException {
        try (BufferedReader bufferedReader = reader;){
            String string = IOStreamUtil.readerTo(reader, lineStrip, ignoreNewLine ? null : Environment.NEW_LINE);
            return string;
        }
    }

    public static String readerTo(BufferedReader reader, boolean lineStrip, String newLine) throws IOException {
        StringBuilder sb = new StringBuilder();
        ArrayList lines = reader.lines().collect(Collectors.toCollection(ArrayList::new));
        for (String line : lines) {
            if (lineStrip) {
                line = line.strip();
            }
            sb.append(line);
            if (newLine == null) continue;
            sb.append(newLine);
        }
        reader.close();
        return sb.toString();
    }

    public static String readerToString(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (reader.ready()) {
            sb.append((char)reader.read());
        }
        reader.close();
        return sb.toString();
    }

    public static void writeFile(byte[] b, File file) throws IOException {
        IOStreamUtil.writeFile(b, file, false);
    }

    public static void writeFile(byte[] b, File file, boolean append) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Can not create file");
        }
        if (!file.canWrite()) {
            throw new IOException("Can not write file");
        }
        try (FileOutputStream os = new FileOutputStream(file, append);){
            IOStreamUtil.exportOutputStream(b, os);
            os.flush();
        }
    }
}

