/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.seppiko.commons.utils.SerializationUtil;

public class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T requireWithElse(T value, T other) {
        return Objects.nonNull(value) ? value : other;
    }

    public static <T> Optional<T> optionalOf(T value) {
        return Optional.ofNullable(value);
    }

    public static Object deepCopy(Object obj) throws IOException, ReflectiveOperationException, SecurityException, NullPointerException {
        Objects.requireNonNull(obj);
        byte[] _tmp = SerializationUtil.serialize(obj);
        return SerializationUtil.deserialize(_tmp, Object.class);
    }
}

