/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexUtil {
    private RegexUtil() {
    }

    public static boolean matches(String regex, CharSequence input) {
        try {
            return Objects.requireNonNull(RegexUtil.getMatcher(regex, input)).matches();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static String find(String regex, CharSequence input) {
        try {
            Matcher matcher = Objects.requireNonNull(RegexUtil.getMatcher(regex, input));
            if (matcher.find()) {
                return matcher.group();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public static String[] split(String regex, CharSequence input) {
        try {
            Pattern pattern = RegexUtil.getPattern(regex);
            return pattern.split(input);
        }
        catch (NullPointerException | PatternSyntaxException runtimeException) {
            return new String[0];
        }
    }

    public static Matcher getMatcher(String regex, CharSequence input) throws NullPointerException, IllegalArgumentException {
        try {
            Pattern pattern = RegexUtil.getPattern(regex);
            return pattern.matcher(Objects.requireNonNull(input));
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Pattern getPattern(String regex) throws PatternSyntaxException, NullPointerException {
        return Pattern.compile(Objects.requireNonNull(regex));
    }
}

