/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import org.seppiko.commons.utils.Environment;

public class SerializationUtil {
    private SerializationUtil() {
    }

    public static <T> byte[] serialize(T object) throws IOException, SecurityException {
        byte[] result;
        if (Objects.isNull(object)) {
            return Environment.EMPTY_BYTE_ARRAY;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(object);
                oos.flush();
            }
            result = baos.toByteArray();
        }
        return result;
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) throws IOException, ClassNotFoundException, SecurityException {
        T result;
        if (bytes == null || bytes.length == 0) {
            throw new NullPointerException("bytes must not be blank.");
        }
        Objects.requireNonNull(clazz, "clazz must not be null.");
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             ObjectInputStream ois = new ObjectInputStream(bais);){
            result = clazz.cast(ois.readObject());
        }
        return result;
    }
}

