/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.Serializable;
import java.util.Objects;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.internal.VersionComparator;

public class VersionUtil
implements Serializable {
    private static final long serialVersionUID = -1334772796709558040L;
    private final String version;
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    private VersionUtil(String versionString) {
        if (StringUtil.isNullOrEmpty(versionString)) {
            throw new IllegalArgumentException("Version string must be not null.");
        }
        int major = 0;
        int minor = 0;
        int patch = 0;
        String qualify = "";
        int length = versionString.length();
        int type = 0;
        int val = 0;
        for (int offset = 0; offset < length; ++offset) {
            char c = versionString.charAt(offset);
            if (c < CharUtil.DIGIT_ZERO || c > CharUtil.DIGIT_NINE) {
                switch (type) {
                    case 0: {
                        major = val;
                        break;
                    }
                    case 1: {
                        minor = val;
                        break;
                    }
                    case 2: {
                        patch = val;
                        qualify = versionString.substring(offset + 1);
                        offset = length;
                    }
                }
                ++type;
                val = 0;
                continue;
            }
            val = val * 10 + c - CharUtil.DIGIT_ZERO;
        }
        if (type == 2) {
            patch = val;
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualify;
        this.version = versionString;
    }

    private VersionUtil(int major, int minor, int patch, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
        this.version = this.generator(major, minor, patch, qualifier);
    }

    private String generator(int major, int minor, int patch, String qualify) {
        String ver = String.format("%d.%d.%d", major, minor, patch);
        if (StringUtil.hasText(qualify)) {
            ver = String.format("%s-%s", ver, qualify);
        }
        return ver;
    }

    public static VersionUtil parser(String versionString) {
        return new VersionUtil(versionString);
    }

    public String versionString() {
        return this.version;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public int compareTo(VersionUtil other) {
        if (null == other) {
            throw new NullPointerException("`other` must be not null.");
        }
        return new VersionComparator().compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionUtil that = (VersionUtil)o;
        return this.version.equals(that.versionString()) || this.major == that.major() && this.minor == that.minor() && this.patch == that.patch() && Objects.equals(this.qualifier, that.qualifier());
    }

    public int hashCode() {
        return Objects.hash(this.version, this.major, this.minor, this.patch, this.qualifier);
    }

    public String toString() {
        return this.version;
    }
}

