/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.seppiko.commons.utils.CharUtil;

public class Base64Util {
    private Base64Util() {
    }

    public static byte[] encode(byte[] data) {
        return Base64.getEncoder().encode(data);
    }

    public static String encodeString(byte[] data) {
        return CharUtil.charsetDecode(StandardCharsets.ISO_8859_1, Base64Util.encode(data)).toString();
    }

    public static byte[] decode(byte[] data) {
        return Base64.getDecoder().decode(data);
    }

    public static byte[] decode(String data) {
        return Base64Util.decode(StandardCharsets.ISO_8859_1.encode(data).array());
    }

    public static String decodeString(byte[] data) {
        return new String(Base64Util.decode(data));
    }

    public static String decodeString(String data) {
        return new String(Base64Util.decode(data));
    }

    public static byte[] encodeUrl(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encode(data);
    }

    public static String encodeUrlString(byte[] data) {
        return CharUtil.charsetDecode(StandardCharsets.ISO_8859_1, Base64Util.encodeUrl(data)).toString();
    }

    public static byte[] decodeUrl(byte[] data) {
        return Base64.getUrlDecoder().decode(data);
    }

    public static byte[] decodeUrl(String data) {
        return Base64Util.decodeUrl(StandardCharsets.ISO_8859_1.encode(data).array());
    }

    public static byte[] encodeMime(byte[] data) {
        return Base64.getMimeEncoder().encode(data);
    }

    public static String encodeMimeString(byte[] data) {
        return CharUtil.charsetDecode(StandardCharsets.ISO_8859_1, Base64Util.encodeMime(data)).toString();
    }

    public static byte[] decodeMime(byte[] data) {
        return Base64.getMimeDecoder().decode(data);
    }

    public static byte[] decodeMime(String data) {
        return Base64Util.decodeMime(StandardCharsets.ISO_8859_1.encode(data).array());
    }
}

