/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.io.Serializable;
import org.seppiko.commons.utils.StringUtil;

public class HexUtil
implements Serializable {
    private static final long serialVersionUID = -6597436615085466807L;
    public static final int HEXADECIMAL_LENGTH = 16;
    public static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] HEXADECIMAL_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final byte[] HEXADECIMAL_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    private HexUtil() {
    }

    public static String encodeString(byte[] data) {
        return HexUtil.encodeString(data, " ", true);
    }

    public static String encodeString(byte[] data, String split, boolean toLowerCase) {
        return StringUtil.convertToString(HexUtil.encode(data, toLowerCase), 2, split);
    }

    public static String encode(byte[] data) {
        return HexUtil.encode(data, true);
    }

    public static String encode(byte[] data, boolean toLowerCase) {
        return new String(HexUtil.encode0(data, toLowerCase ? HEXADECIMAL : HEXADECIMAL_UPPER));
    }

    private static char[] encode0(byte[] data, char[] hexChar) {
        char[] hex = new char[data.length * 2];
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            hex[j++] = hexChar[(0xF0 & b) >> 4];
            hex[j++] = hexChar[0xF & b];
        }
        return hex;
    }

    public static byte[] decodeString(String data) throws IllegalArgumentException, NullPointerException {
        return HexUtil.decode(data, " ");
    }

    public static byte[] decode(String data, String split) throws IllegalArgumentException, NullPointerException {
        return HexUtil.decode(StringUtil.convertToCharArray(data, split));
    }

    public static byte[] decode(char[] data) throws IllegalArgumentException, NullPointerException {
        if (null == data || data.length == 0) {
            throw new NullPointerException();
        }
        return HexUtil.decode0(data);
    }

    private static byte[] decode0(char[] data) {
        byte[] hex = new byte[data.length / 2];
        int i = 0;
        int j = 0;
        while (i < hex.length) {
            int f = HexUtil.toDigit(data[j]) << 4;
            hex[i] = (byte)((f |= HexUtil.toDigit(data[j + 1])) & 0xFF);
            ++i;
            j += 2;
        }
        return hex;
    }

    private static int toDigit(char hexChar) throws IllegalArgumentException {
        byte digit = HEXADECIMAL_DECODE_TABLE[hexChar];
        if (digit < 0) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }
}

