/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.util.Objects;
import java.util.zip.Checksum;

public class CRC24
implements Checksum {
    private static final int CRC24_INIT = 11994318;
    private static final int CRC24_POLY = 25578747;
    private static final int CRC24_OUTMASK = 0xFFFFFF;
    private int crc = 11994318;

    @Override
    public void update(int b) {
        this.crc ^= b << 16;
        for (int i = 0; i < 8; ++i) {
            this.crc <<= 1;
            if ((this.crc & 0x1000000) == 0) continue;
            this.crc ^= 0x1864CFB;
        }
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.updateCheck(b, off, len);
        int i = off;
        while (len > 0) {
            this.update(b[i]);
            ++i;
            --len;
        }
    }

    private void updateCheck(byte[] b, int off, int len) throws NullPointerException, ArrayIndexOutOfBoundsException {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0) {
            throw new IllegalArgumentException();
        }
        if (off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public long getValue() {
        return this.crc & 0xFFFFFF;
    }

    @Override
    public void reset() {
        this.crc = 11994318;
    }
}

