/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.util.zip.CRC32C;
import org.seppiko.commons.utils.crypto.CRC16MAXIM;
import org.seppiko.commons.utils.crypto.CRC24;
import org.seppiko.commons.utils.crypto.CRC64ECMA182;

public class CRCUtil {
    private CRCUtil() {
    }

    public static class CRC64E {
        private static final CRC64ECMA182 crc64e = new CRC64ECMA182();

        private CRC64E() {
        }

        public static long encode(byte[] data) {
            crc64e.update(data);
            return crc64e.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc64 = CRC64E.encode(data);
            return Long.toHexString(crc64);
        }
    }

    public static class CRC32 {
        private static final CRC32C crc32 = new CRC32C();

        private CRC32() {
        }

        public static long encode(byte[] data) {
            crc32.update(data);
            return crc32.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc32 = CRC32.encode(data);
            return Long.toHexString(crc32);
        }
    }

    public static class CRC24C {
        private static final CRC24 crc24 = new CRC24();

        private CRC24C() {
        }

        public static long encode(byte[] data) {
            crc24.update(data);
            return crc24.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc24 = CRC24C.encode(data);
            return Long.toHexString(crc24);
        }
    }

    public static class CRC16M {
        private static final CRC16MAXIM crc16MAXIM = new CRC16MAXIM();

        private CRC16M() {
        }

        public static long encode(byte[] data) {
            crc16MAXIM.update(data);
            return crc16MAXIM.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc16 = CRC16M.encode(data);
            return Long.toHexString(crc16);
        }
    }
}

