/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.crypto.spec.KeySpecUtil;

public class CryptoUtil {
    public static final Provider NONPROVIDER = null;

    private CryptoUtil() {
    }

    public static Provider getProvider(String providerName) {
        if (StringUtil.isNullOrEmpty(providerName)) {
            return NONPROVIDER;
        }
        return Security.getProvider(providerName);
    }

    public static byte[] cipher(String algorithm, Provider provider, int opmode, Key key, AlgorithmParameterSpec params, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = CryptoUtil.cipher(algorithm, provider);
        if (Objects.isNull(params)) {
            cipher.init(opmode, key);
        } else {
            cipher.init(opmode, key, params);
        }
        return cipher.doFinal(data);
    }

    public static byte[] cipher(String algorithm, String providerName, int opmode, Key key, AlgorithmParameterSpec params, byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        Provider p = CryptoUtil.getProvider(providerName);
        return CryptoUtil.cipher(algorithm, p, opmode, key, params, data);
    }

    public static Cipher cipher(String algorithm, Provider provider) throws NoSuchPaddingException, NoSuchAlgorithmException {
        if (provider == NONPROVIDER) {
            return Cipher.getInstance(algorithm);
        }
        return Cipher.getInstance(algorithm, provider);
    }

    public static byte[] md(String algorithm, Provider provider, byte[] data) throws NoSuchAlgorithmException, NullPointerException {
        MessageDigest md = CryptoUtil.md(algorithm, provider);
        md.update(data);
        return md.digest();
    }

    public static MessageDigest md(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException {
        if (provider == NONPROVIDER) {
            return MessageDigest.getInstance(algorithm);
        }
        return MessageDigest.getInstance(algorithm, provider);
    }

    public static byte[] mac(String algorithm, Provider provider, String keyAlgorithm, byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, NullPointerException {
        return CryptoUtil.mac(algorithm, provider, KeySpecUtil.getSecret(key, keyAlgorithm), data);
    }

    public static byte[] mac(String algorithm, Provider provider, Key key, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, NullPointerException {
        Mac mac = CryptoUtil.mac(algorithm, provider);
        mac.init(key);
        return mac.doFinal(data);
    }

    public static Mac mac(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException {
        if (provider == NONPROVIDER) {
            return Mac.getInstance(algorithm);
        }
        return Mac.getInstance(algorithm, provider);
    }
}

