/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.seppiko.commons.utils.crypto.CryptoUtil;
import org.seppiko.commons.utils.crypto.spec.KeySpecUtil;

public class HKDF {
    private final String algorithm;
    private final Provider provider;

    private HKDF(String algorithm, Provider provider) {
        this.algorithm = algorithm;
        this.provider = provider;
    }

    public static HKDF from(String algorithm) {
        return HKDF.from(algorithm, CryptoUtil.NONPROVIDER);
    }

    public static HKDF from(String algorithm, Provider provider) {
        return new HKDF(algorithm, provider);
    }

    public byte[] extract(byte[] salt, byte[] ikm) {
        return this.extract(this.createSecretKey(salt), ikm);
    }

    public byte[] extract(SecretKey salt, byte[] ikm) {
        return new Extractor(this.algorithm, this.provider).execute(salt, ikm);
    }

    public byte[] expand(byte[] pseudoRandomKey, byte[] info, int outLengthBytes) {
        return this.expand(this.createSecretKey(pseudoRandomKey), info, outLengthBytes);
    }

    public byte[] expand(SecretKey pseudoRandomKey, byte[] info, int outLengthBytes) {
        return new Expander(this.algorithm, this.provider).execute(pseudoRandomKey, info, outLengthBytes);
    }

    private SecretKey createSecretKey(byte[] salt) {
        return KeySpecUtil.getSecret(salt, this.algorithm);
    }

    static final class Extractor {
        private final String algorithmName;
        private final Provider provider;
        private Mac mac;

        Extractor(String algorithmName, Provider provider) {
            this.algorithmName = algorithmName;
            this.provider = provider;
            this.createMac();
        }

        private void createMac() {
            try {
                this.mac = CryptoUtil.mac(this.algorithmName, this.provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }

        byte[] execute(SecretKey salt, byte[] ikm) {
            try {
                if (salt == null) {
                    salt = this.createEmptySecretKey();
                }
                this.mac.init(salt);
                return this.mac.doFinal(ikm);
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(e);
            }
        }

        SecretKey createEmptySecretKey() {
            int macLength = this.mac.getMacLength();
            return KeySpecUtil.getSecret(new byte[macLength], this.algorithmName);
        }
    }

    static final class Expander {
        private final String algorithmName;
        private final Provider provider;

        Expander(String algorithmName, Provider provider) {
            this.algorithmName = algorithmName;
            this.provider = provider;
        }

        byte[] execute(SecretKey pseudoRandomKey, byte[] info, int outLengthBytes) {
            Mac mac;
            if (Objects.isNull(pseudoRandomKey)) {
                throw new IllegalArgumentException("provided pseudoRandomKey must not be null");
            }
            if (null == info) {
                info = new byte[]{};
            }
            if (outLengthBytes < 1) {
                throw new IllegalArgumentException("out length bytes must be positive");
            }
            try {
                mac = CryptoUtil.mac(this.algorithmName, this.provider);
                mac.init(pseudoRandomKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            byte[] blockN = new byte[]{};
            int hashLen = mac.getMacLength();
            if (outLengthBytes > 255 * hashLen) {
                throw new IllegalArgumentException("outLengthBytes must be less than or equal to 255*HashLen");
            }
            int n = outLengthBytes % hashLen == 0 ? outLengthBytes / hashLen : outLengthBytes / hashLen + 1;
            ByteBuffer generatedBytes = ByteBuffer.allocate(Math.multiplyExact(n, hashLen));
            for (int roundNum = 1; roundNum <= n; ++roundNum) {
                mac.reset();
                ByteBuffer t = ByteBuffer.allocate(blockN.length + info.length + 1);
                t.put(blockN);
                t.put(info);
                t.put((byte)roundNum);
                blockN = mac.doFinal(t.array());
                generatedBytes.put(blockN);
            }
            byte[] result = new byte[outLengthBytes];
            generatedBytes.rewind();
            generatedBytes.get(result, 0, outLengthBytes);
            return result;
        }
    }
}

