/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import org.seppiko.commons.utils.codec.Base64Util;
import org.seppiko.commons.utils.codec.HexUtil;
import org.seppiko.commons.utils.crypto.CryptoUtil;
import org.seppiko.commons.utils.crypto.HmacAlgorithms;
import org.seppiko.commons.utils.crypto.KeyUtil;
import org.seppiko.commons.utils.crypto.MessageDigestAlgorithms;
import org.seppiko.commons.utils.crypto.PHCFormatUtil;
import org.seppiko.commons.utils.crypto.spec.KeySpecUtil;

public class HashUtil {
    private HashUtil() {
    }

    public static byte[] mdHash(MessageDigestAlgorithms algorithm, Provider provider, byte[] data) throws IllegalArgumentException {
        try {
            return CryptoUtil.md(algorithm.getName(), provider, data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String mdHashString(MessageDigestAlgorithms algorithm, Provider provider, byte[] data) throws IllegalArgumentException {
        return HexUtil.encode(HashUtil.mdHash(algorithm, provider, data));
    }

    public static byte[] hmacHash(HmacAlgorithms algorithm, Provider provider, byte[] data, byte[] key) throws InvalidKeyException, IllegalArgumentException {
        try {
            return CryptoUtil.mac(algorithm.getName(), provider, algorithm.getName(), data, key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException();
        }
    }

    public static String hmacHashString(HmacAlgorithms algorithm, Provider provider, byte[] data, byte[] key) throws InvalidKeyException, IllegalArgumentException {
        return HexUtil.encode(HashUtil.hmacHash(algorithm, provider, data, key));
    }

    public static byte[] pbkdf2Hash(HmacAlgorithms algorithm, Provider provider, char[] password, byte[] salt, int iterations, int keySize) throws IllegalArgumentException {
        try {
            if (algorithm.getName().contains("PBE")) {
                throw new NoSuchAlgorithmException("Algorithm must be exclude PBE.");
            }
            return KeyUtil.secretKeyFactory("PBKDF2With" + algorithm.getName(), provider, KeySpecUtil.getPBE(password, salt, iterations, keySize));
        }
        catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String pbkdf2HashString(HmacAlgorithms algorithm, Provider provider, char[] password, byte[] salt, int iterations, int keySize) throws IllegalArgumentException {
        byte[] result = HashUtil.pbkdf2Hash(algorithm, provider, password, salt, iterations, keySize);
        String saltBase64 = Base64Util.encodeString(salt);
        String hashBase64 = Base64Util.encodeString(result);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("i", iterations);
        return PHCFormatUtil.format("pbkdf2-" + algorithm.getName(), null, params, saltBase64, hashBase64);
    }
}

