/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.seppiko.commons.utils.StringUtil;

public class NMPUtil
implements Serializable {
    private static final long serialVersionUID = -215141540814890802L;
    private final String name;
    private final String mode;
    private final String padding;

    public NMPUtil(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        if (StringUtil.isNullOrEmpty(algorithm)) {
            throw new NullPointerException("algorithm must not be null.");
        }
        if (algorithm.indexOf(47) < 0) {
            this.name = algorithm;
            this.mode = null;
            this.padding = null;
        } else {
            String[] strs = algorithm.split("/");
            if (strs.length == 2) {
                this.name = strs[0];
                this.mode = strs[1];
                this.padding = null;
            } else if (strs.length == 3) {
                this.name = strs[0];
                this.mode = strs[1];
                this.padding = strs[2];
            } else {
                throw new NoSuchAlgorithmException("Algorithm string parser failed.");
            }
        }
    }

    public NMPUtil(String name, String mode, String padding) throws NullPointerException {
        if (StringUtil.isNullOrEmpty(name)) {
            throw new NullPointerException("name must not be null.");
        }
        this.name = name;
        this.mode = mode;
        this.padding = padding;
    }

    public String getName() {
        return this.name;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NMPUtil that = (NMPUtil)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.mode, that.mode) && Objects.equals(this.padding, that.padding);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mode, this.padding);
    }

    public String toString() {
        return StringUtil.convertJoinerString("/", this.name, this.mode, this.padding);
    }
}

