/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.util.LinkedHashMap;
import java.util.Map;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.CollectionUtil;
import org.seppiko.commons.utils.RegexUtil;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.exceptions.IllegalFormatException;

public class PHCFormatUtil {
    private static final char SEPARATION = CharUtil.DOLLAR_SIGN.charValue();
    private static final String VERSION_KEY = "v=";

    private PHCFormatUtil() {
    }

    public static String format(String id, String version, Map<String, Object> params, String salt, String hash) {
        return PHCFormatUtil.format(new Entity(id, version, params, salt, hash));
    }

    public static String format(Entity entity) {
        StringBuilder sb = new StringBuilder();
        sb.append(SEPARATION);
        sb.append(StringUtil.requireNonBlank(entity.id()));
        if (!StringUtil.isNullOrEmpty(entity.version())) {
            sb.append(SEPARATION);
            sb.append(VERSION_KEY).append(entity.version());
        }
        if (null != entity.params() && !entity.params().isEmpty()) {
            sb.append(SEPARATION);
            sb.append(CollectionUtil.toString(entity.params(), key -> key, Object::toString, (CharSequence)"=", (CharSequence)","));
        }
        if (!StringUtil.isNullOrEmpty(entity.salt())) {
            sb.append(SEPARATION);
            sb.append(entity.salt());
            if (!StringUtil.isNullOrEmpty(entity.hash())) {
                sb.append(SEPARATION);
                sb.append(entity.hash());
            }
        }
        return sb.toString();
    }

    public static Entity parser(String phc) {
        PHCFormatUtil.check(phc);
        String[] strs = RegexUtil.split("\\" + SEPARATION, phc);
        String id = strs[1];
        String version = null;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String salt = null;
        String hash = null;
        int nextIndex = 2;
        if (strs[nextIndex].startsWith(VERSION_KEY)) {
            version = strs[nextIndex].substring(VERSION_KEY.length());
            ++nextIndex;
        }
        if (strs[nextIndex].matches("\\w+=\\w+,?")) {
            CollectionUtil.fromString(params, strs[nextIndex], "=", ",", String.class, Object.class);
            ++nextIndex;
        }
        if (nextIndex < strs.length) {
            salt = strs[nextIndex++];
        }
        if (nextIndex < strs.length) {
            hash = strs[nextIndex];
        }
        return new Entity(id, version, params, salt, hash);
    }

    private static void check(String phc) {
        if (phc.charAt(0) != SEPARATION) {
            throw new IllegalFormatException("PHC String must start with '" + SEPARATION + "'.");
        }
    }

    public record Entity(String id, String version, Map<String, Object> params, String salt, String hash) {
        @Override
        public String toString() {
            return "{id=" + this.id + ", version=" + this.version + ", param={" + CollectionUtil.toString(this.params, key -> "\"" + key + "\"", Object::toString, (CharSequence)": ", (CharSequence)",") + "}, salt=" + this.salt + ", hash=" + this.hash + "}";
        }
    }
}

