/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.util.Objects;

public enum HttpMethod {
    GET,
    POST,
    PUT,
    DELETE,
    HEAD,
    OPTIONS,
    CONNECT,
    TRACE,
    PATCH;

    private static final HttpMethod[] VALUES;

    public static HttpMethod resolve(String name) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(name, "name must not be null.");
        String methodName = name.strip().toUpperCase();
        for (HttpMethod method : VALUES) {
            if (!method.name().equals(methodName)) continue;
            return method;
        }
        throw new IllegalArgumentException("name not found.");
    }

    static {
        VALUES = HttpMethod.values();
    }
}

