/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    private ImageUtil() {
    }

    public static byte[] compressor(BufferedImage image, String formatName, float quality, boolean enableProgressiveMode) throws IOException, NullPointerException, IllegalArgumentException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
                try {
                    Objects.requireNonNull(image, "Image must be not null.");
                    ImageWriter writer = ImageIO.getImageWritersByFormatName(formatName).next();
                    writer.setOutput(ios);
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    if (param.canWriteCompressed()) {
                        param.setCompressionMode(2);
                        param.setCompressionQuality(quality);
                    }
                    if (enableProgressiveMode && param.canWriteProgressive()) {
                        param.setProgressiveMode(1);
                    }
                    writer.write(null, new IIOImage(image, null, null), param);
                    writer.dispose();
                    byArray = baos.toByteArray();
                    if (ios == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ios != null) {
                        try {
                            ios.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ios.close();
            }
            return byArray;
        }
    }

    public static byte[] writeImage(BufferedImage image, String formatName) throws IOException, NullPointerException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Objects.requireNonNull(image);
            if (ImageIO.write((RenderedImage)image, formatName, baos)) {
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }
}

