/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.internal;

import java.util.Comparator;
import org.seppiko.commons.utils.VersionUtil;

public class VersionComparator
implements Comparator<VersionUtil> {
    private static final int EQUAL = 0;
    private static final int GREATER = 1;
    private static final int LESSER = -1;

    @Override
    public int compare(VersionUtil left, VersionUtil right) {
        if (null == left || null == right) {
            throw new NullPointerException("Version must be not null.");
        }
        if (left.equals(right)) {
            return 0;
        }
        if (left.major() > right.major()) {
            return 1;
        }
        if (left.major() < right.major()) {
            return -1;
        }
        if (left.minor() > right.minor()) {
            return 1;
        }
        if (left.minor() < right.minor()) {
            return -1;
        }
        if (left.patch() > right.patch()) {
            return 1;
        }
        if (left.patch() < right.patch()) {
            return -1;
        }
        return left.qualifier().compareTo(right.qualifier());
    }
}

