/*
 * Copyright 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * interface proxy implement class interface.
 *
 * @param <T> interface class type.
 * @author Leonard Woo
 */
public interface ProxyHandler<T> extends InvocationHandler {

  /**
   * Proxy method invoke.
   *
   * @param proxy proxy object.
   * @param method target object method.
   * @param args target method argument.
   * @return target method return.
   * @throws Throwable target method throw.
   */
  @Override
  T invoke(Object proxy, Method method, Object[] args) throws Throwable;
}
