/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;

public class URLCodecUtil {
    private static final Charset defaultCharset = StandardCharsets.UTF_8;

    private URLCodecUtil() {
    }

    public static String getDefaultCharset() {
        return defaultCharset.name();
    }

    public static String encode(String str) throws NullPointerException {
        return URLCodecUtil.encode(str, defaultCharset);
    }

    public static String encode(String str, String charsetName) throws UnsupportedEncodingException, NullPointerException {
        try {
            Objects.requireNonNull(charsetName);
            Charset charset = Charset.forName(charsetName);
            return URLCodecUtil.encode(str, charset);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(charsetName);
        }
        catch (IllegalArgumentException e) {
            throw new NullPointerException();
        }
    }

    public static String encode(String str, Charset charset) throws NullPointerException {
        return URLEncoder.encode(str, charset);
    }

    public static String decode(String str) throws UnsupportedEncodingException, NullPointerException {
        return URLCodecUtil.decode(str, defaultCharset);
    }

    public static String decode(String str, String charsetName) throws UnsupportedEncodingException, NullPointerException {
        try {
            Objects.requireNonNull(charsetName);
            Charset charset = Charset.forName(charsetName);
            return URLCodecUtil.decode(str, charset);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(charsetName);
        }
        catch (IllegalArgumentException e) {
            throw new NullPointerException();
        }
    }

    public static String decode(String str, Charset charset) throws UnsupportedEncodingException, NullPointerException {
        try {
            return URLDecoder.decode(str, charset);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedEncodingException(charset.name());
        }
    }
}

