/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectUtil {
    public static <T> T safeNull(T t, T defaultValue) {
        return ObjectUtil.isNull(t) ? defaultValue : t;
    }

    public static <T> boolean isArray(T obj) {
        return ObjectUtil.notNull(obj) && obj.getClass().isArray();
    }

    public static <T> boolean isEmpty(T[] array) {
        return ObjectUtil.isNull(array) || array.length == 0;
    }

    public static <T> boolean isNull(T obj) {
        return null == obj;
    }

    public static <T> boolean isNull(T[] obj) {
        return null == obj;
    }

    public static <T> boolean notNull(T obj) {
        return obj != null;
    }

    public static <T> boolean notNull(T[] obj) {
        return null != obj;
    }

    public static Object deepCopy(Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Object targetObj = ois.readObject();
        oos.close();
        baos.close();
        ois.close();
        return targetObj;
    }
}

