/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.seppiko.commons.utils.codec.HmacAlgorithms;
import org.seppiko.commons.utils.codec.MessageDigestAlgorithms;
import org.seppiko.commons.utils.crypto.CryptoUtil;
import org.seppiko.commons.utils.crypto.spec.KeySpecUtil;

public class HashUtil {
    public static byte[] mdCrypt(MessageDigestAlgorithms algorithm, byte[] data) throws IllegalArgumentException {
        try {
            return CryptoUtil.md(algorithm.getName(), data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException();
        }
    }

    public static byte[] hmacCrypt(HmacAlgorithms algorithm, byte[] data, byte[] key) throws InvalidKeyException, IllegalArgumentException {
        try {
            return CryptoUtil.mac(algorithm.getName(), algorithm.getName(), data, key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException();
        }
    }

    public static byte[] pbkdf2Crypt(HmacAlgorithms algorithm, char[] password, byte[] salt, int iterations, int keySize) {
        try {
            return CryptoUtil.secretKeyFactory("PBKDF2With" + algorithm, KeySpecUtil.getPBE(password, salt, iterations, keySize));
        }
        catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

