/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.List;

public class HttpHeaders {
    public static final HttpHeaders NO_HEADERS = new HttpHeaders();
    private LinkedHashMap<String, ArrayList<String>> headers;
    private final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char HTTP_HEADER_VALUE_SEPARTOR = ';';

    private HttpHeaders() {
        this.headers = new LinkedHashMap();
    }

    public static HttpHeaders setHeader(String name, String ... values) {
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader(name, values);
        return headers;
    }

    public void setHeaders(String name, String ... values) {
        this.headers.put(name, new ArrayList<String>(List.of(values)));
    }

    public void setHeaders(LinkedHashMap<String, ArrayList<String>> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String ... values) throws IllegalArgumentException {
        if (this.headers.containsKey(name)) {
            ArrayList<String> valueOld = this.headers.get(name);
            ArrayList valueNew = (ArrayList)List.of(values);
            for (String s : valueOld) {
                if (valueNew.contains(s)) continue;
                try {
                    valueNew.add(s);
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException | UnsupportedOperationException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            this.headers.put(name, valueNew);
        } else {
            this.setHeaders(name, values);
        }
    }

    public String[] getHeaderList() throws IllegalCallerException, IllegalArgumentException {
        return this.headers.isEmpty() ? this.EMPTY_STRING_ARRAY : this.headerHeadler(this.headers);
    }

    private String[] headerHeadler(LinkedHashMap<String, ArrayList<String>> headerMap) throws IllegalCallerException, IllegalArgumentException {
        ArrayList headerList = new ArrayList();
        try {
            headerMap.forEach((key, value) -> {
                headerList.add(key);
                headerList.add(this.valuesHeadler((ArrayList<String>)value));
            });
            return (String[])headerList.toArray(String[]::new);
        }
        catch (ArrayStoreException | ClassCastException | ConcurrentModificationException ex) {
            throw new IllegalCallerException(ex);
        }
        catch (IllegalArgumentException | UnsupportedOperationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NullPointerException nullPointerException) {
            return this.EMPTY_STRING_ARRAY;
        }
    }

    private String valuesHeadler(ArrayList<String> valueList) {
        StringBuilder sb = new StringBuilder();
        valueList.forEach(e -> {
            sb.append((String)e);
            sb.append(';');
            sb.append(" ");
        });
        return sb.deleteCharAt(sb.lastIndexOf(";")).toString().stripTrailing();
    }
}

