/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum MediaType {
    ALL("*", "*"),
    APPLICATION_OCTET_STREAM("application", "octet-stream"),
    TEXT_EVENT_STREAM("text", "event-stream"),
    APPLICATION_ATOM_XML("application", "atom+xml"),
    APPLICATION_RSS_XML("application", "rss+xml"),
    APPLICATION_SOAP_XML("application", "soap+xml"),
    APPLICATION_FORM_URLENCODED("application", "x-www-form-urlencoded"),
    MULTIPART_FORM_DATA("multipart", "form-data"),
    APPLICATION_JSON("application", "json"),
    APPLICATION_JSON_UTF8("application", "json", StandardCharsets.UTF_8),
    APPLICATION_XML("application", "xml"),
    TEXT_XML("text", "xml"),
    APPLICATION_XHTML_XML("application", "xhtml+xml"),
    TEXT_CSS("text", "css"),
    TEXT_HTML("text", "html"),
    TEXT_JAVASCRIPT("text", "javascript"),
    APPLICATION_PDF("application", "pdf"),
    FONT_OTF("font", "otf"),
    FONT_TTF("font", "ttf"),
    FONT_WOFF("font", "woff"),
    FONT_WOFF2("font", "woff2"),
    IMAGE_AVIF("image", "avif"),
    IMAGE_GIF("image", "gif"),
    IMAGE_JPEG("image", "jpeg"),
    IMAGE_PNG("image", "png"),
    IMAGE_SVG("image", "svg+xml"),
    IMAGE_WEBP("image", "webp"),
    IMAGE_ICO("image", "x-icon"),
    IMAGE_JPEG_XL("image", "jxl"),
    IMAGE_HEIC("image", "heic"),
    TEXT_ASCIIDOC("text", "asciidoc"),
    TEXT_CSV("text", "csv"),
    TEXT_MARKDOWN("text", "markdown"),
    TEXT_PLAIN("text", "plain");

    private final String type;
    private final String subtype;
    private final Charset charset;
    private static final Map<String, MediaType> MEDIA_TYPE_MAP;

    private MediaType(String type, String subtype) {
        this(type, subtype, null);
    }

    private MediaType(String type, String subtype, Charset charset) {
        this.type = type;
        this.subtype = subtype;
        this.charset = charset;
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        sb.append("/");
        sb.append(this.subtype);
        if (this.charset != null) {
            sb.append("; chatset=");
            sb.append(this.charset.name());
        }
        return sb.toString();
    }

    public static MediaType findByValue(String value) {
        return MEDIA_TYPE_MAP.get(value.toLowerCase());
    }

    static {
        ConcurrentHashMap<String, MediaType> map = new ConcurrentHashMap<String, MediaType>();
        for (MediaType type : MediaType.values()) {
            map.put(type.getValue(), type);
        }
        MEDIA_TYPE_MAP = Collections.unmodifiableMap(map);
    }
}

