/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.util.Objects;
import org.seppiko.commons.utils.StringUtil;

public class VersionUtil {
    private final String version;
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    private VersionUtil(String versionString) {
        this.version = versionString;
        int major = 0;
        int minor = 0;
        int patch = 0;
        String qualif = "";
        int length = this.version.length();
        int type = 0;
        int val = 0;
        for (int offset = 0; offset < length; ++offset) {
            char car = this.version.charAt(offset);
            if (car < '0' || car > '9') {
                switch (type) {
                    case 0: {
                        major = val;
                        break;
                    }
                    case 1: {
                        minor = val;
                        break;
                    }
                    case 2: {
                        patch = val;
                        qualif = this.version.substring(offset);
                        offset = length;
                        break;
                    }
                }
                ++type;
                val = 0;
                continue;
            }
            val = val * 10 + car - 48;
        }
        if (type == 2) {
            patch = val;
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualif;
    }

    private VersionUtil(int major, int minor, int patch, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
        String ver = major + "." + minor + "." + patch;
        if (StringUtil.hasText(qualifier)) {
            ver = ver + ver + "." + qualifier;
        }
        this.version = ver;
    }

    public static VersionUtil parser(String versionString) {
        return new VersionUtil(versionString);
    }

    public String versionString() {
        return this.version;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public boolean equals(int major, int minor, int patch) {
        return this.equals(new VersionUtil(major, minor, patch, ""));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionUtil that = (VersionUtil)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.version.equals(that.version) && Objects.equals(this.qualifier, that.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.major, this.minor, this.patch, this.qualifier);
    }
}

