/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.StringUtil;

public class HexUtil {
    public static char[] encodeWithInteger(byte[] data) {
        char[] hexs = new char[data.length * 2];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            char[] hex = Integer.toHexString(data[i] & 0xFF).toCharArray();
            hexs[j] = hex.length == 1 ? 48 : hex[0];
            hexs[j + 1] = hex.length == 1 ? hex[0] : hex[1];
            ++i;
            j += 2;
        }
        return hexs;
    }

    public static String encodeToString(byte[] data) {
        return HexUtil.encodeToString(data, " ");
    }

    public static String encodeToString(byte[] data, String split) {
        return StringUtil.convertToString(HexUtil.encode(data), 2, split);
    }

    public static char[] encode(byte[] data) {
        return HexUtil.encode(data, true);
    }

    public static char[] encode(byte[] data, boolean toLowerCase) {
        return HexUtil.encode(data, toLowerCase ? Environment.HEXADECIMAL : Environment.HEXADECIMAL_UPPER);
    }

    private static char[] encode(byte[] data, char[] hexChar) {
        char[] hex = new char[32];
        int i = 0;
        int j = 0;
        while (i < 16) {
            hex[j] = hexChar[(0xF0 & data[i]) >>> 4];
            hex[j + 1] = hexChar[0xF & data[i]];
            ++i;
            j += 2;
        }
        return hex;
    }

    public static byte[] decodeString(String data, String split) {
        return HexUtil.decode(StringUtil.convertToCharArray(data, split));
    }

    public static byte[] decode(char[] data) throws IllegalArgumentException {
        byte[] hex = new byte[data.length / 2];
        int i = 0;
        int j = 0;
        while (i < hex.length) {
            int f = HexUtil.toDigit(data[j]) << 4;
            hex[i] = (byte)((f |= HexUtil.toDigit(data[j + 1])) & 0xFF);
            ++i;
            j += 2;
        }
        return hex;
    }

    private static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit < 0) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }
}

