/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.seppiko.commons.utils.crypto.CryptoUtil;

public class AsymmetricUtil {
    private final String algorithm;
    private Provider provider = CryptoUtil.NONPROVIDER;
    private AlgorithmParameterSpec params = null;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public AsymmetricUtil(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setKeyPair(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public void setParameterSpec(AlgorithmParameterSpec params) {
        this.params = params;
    }

    public byte[] encrypt(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, NullPointerException {
        Objects.requireNonNull(this.publicKey);
        return CryptoUtil.cipher(this.algorithm, this.provider, 1, (Key)this.publicKey, this.params, data);
    }

    public byte[] decrypt(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, NullPointerException {
        Objects.requireNonNull(this.privateKey);
        return CryptoUtil.cipher(this.algorithm, this.provider, 2, (Key)this.privateKey, this.params, data);
    }

    public byte[] encryptWithPrivateKey(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, NullPointerException {
        Objects.requireNonNull(this.privateKey);
        return CryptoUtil.cipher(this.algorithm, this.provider, 1, (Key)this.privateKey, this.params, data);
    }

    public byte[] decryptWithPublicKey(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, NullPointerException {
        Objects.requireNonNull(this.publicKey);
        return CryptoUtil.cipher(this.algorithm, this.provider, 2, (Key)this.publicKey, this.params, data);
    }
}

