/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import org.seppiko.commons.utils.ObjectUtil;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.crypto.GeneratorUtil;
import org.seppiko.commons.utils.crypto.spec.KeySpecUtil;

public class CryptoUtil {
    public static final Provider NONPROVIDER = null;

    public static Provider getProvider(String providerName) throws IllegalArgumentException, NoSuchProviderException {
        if (StringUtil.isEmpty(providerName)) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(providerName);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return p;
    }

    public static byte[] cipher(String algorithm, Provider provider, int opmode, Key key, AlgorithmParameterSpec params, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        Cipher cipher2 = cipher = ObjectUtil.isNull(provider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        if (ObjectUtil.isNull(params)) {
            cipher.init(opmode, key);
        } else {
            cipher.init(opmode, key, params);
        }
        return cipher.doFinal(data);
    }

    public static byte[] cipher(String algorithm, String providerName, int opmode, Key key, AlgorithmParameterSpec params, byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        Provider p = StringUtil.isEmpty(providerName) ? NONPROVIDER : Security.getProvider(providerName);
        return CryptoUtil.cipher(algorithm, p, opmode, key, params, data);
    }

    public static byte[] md(String algorithm, byte[] data) throws NoSuchAlgorithmException, NullPointerException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(data);
        return md.digest();
    }

    public static byte[] md(String algorithm, Provider provider, byte[] data) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        MessageDigest md = MessageDigest.getInstance(algorithm, provider);
        md.update(data);
        return md.digest();
    }

    public static byte[] mac(String algorithm, String keyAlgorithm, byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, NullPointerException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(KeySpecUtil.getSecret(key, keyAlgorithm));
        return mac.doFinal(data);
    }

    public static byte[] mac(String algorithm, Provider provider, String keyAlgorithm, byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, NullPointerException {
        Mac mac = Mac.getInstance(algorithm, provider);
        mac.init(KeySpecUtil.getSecret(key, keyAlgorithm));
        return mac.doFinal(data);
    }

    public static byte[] secretKeyFactory(String algorithm, Provider provider, KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, IllegalArgumentException, NullPointerException {
        return CryptoUtil.secretKeyFactory(algorithm, provider).generateSecret(keySpec).getEncoded();
    }

    public static SecretKeyFactory secretKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        if (ObjectUtil.isNull(provider)) {
            return SecretKeyFactory.getInstance(algorithm);
        }
        return SecretKeyFactory.getInstance(algorithm, provider);
    }

    public static KeyFactory keyFactory(String algorithm, Provider provider) throws NullPointerException, NoSuchAlgorithmException, IllegalArgumentException {
        if (ObjectUtil.isNull(provider)) {
            return KeyFactory.getInstance(algorithm);
        }
        return KeyFactory.getInstance(algorithm, provider);
    }

    public static byte[] keyAgreement(String algorithm, Provider provider, Key privateKey, Key publicKey) throws NoSuchAlgorithmException, NullPointerException, InvalidKeyException {
        KeyAgreement ka = ObjectUtil.isNull(provider) ? KeyAgreement.getInstance(algorithm) : KeyAgreement.getInstance(algorithm, provider);
        ka.init(privateKey);
        ka.doPhase(publicKey, true);
        return ka.generateSecret();
    }

    public static byte[] secureRandom(String algorithm, Provider provider, SecureRandomParameters params, int seedSize) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        if (StringUtil.isEmpty(algorithm) && provider == null && params == null) {
            throw new NullPointerException();
        }
        SecureRandom srand = params == null && provider == null ? GeneratorUtil.secureRandom(algorithm) : (params == null ? GeneratorUtil.secureRandom(algorithm, provider) : GeneratorUtil.secureRandom(algorithm, provider, params));
        return srand.generateSeed(seedSize);
    }
}

