/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.seppiko.commons.utils.crypto.CryptoUtil;
import org.seppiko.commons.utils.crypto.NMPUtil;

public class SymmetricUtil {
    private final NMPUtil algorithm;
    private Provider provider = CryptoUtil.NONPROVIDER;
    private Key key;
    private AlgorithmParameterSpec params = null;

    public SymmetricUtil(String algorithm) throws NoSuchAlgorithmException {
        this.algorithm = new NMPUtil(algorithm);
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setParameterSpec(AlgorithmParameterSpec params) {
        this.params = params;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public byte[] encrypt(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        return CryptoUtil.cipher(this.algorithm.toString(), this.provider, 1, this.key, this.params, data);
    }

    public byte[] decrypt(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        return CryptoUtil.cipher(this.algorithm.toString(), this.provider, 2, this.key, this.params, data);
    }
}

