/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto.spec;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.security.spec.XECPublicKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.seppiko.commons.utils.ObjectUtil;
import org.seppiko.commons.utils.StringUtil;

public class KeySpecUtil {
    public static SecretKeySpec getSecret(byte[] key, String algorithm) throws NullPointerException, IllegalArgumentException {
        if (ObjectUtil.isNull(key)) {
            throw new NullPointerException("key missing");
        }
        return KeySpecUtil.getSecret(key, 0, key.length, algorithm);
    }

    public static SecretKeySpec getSecret(byte[] key, int off, int len, String algorithm) throws NullPointerException, IllegalArgumentException {
        if (ObjectUtil.isNull(key) || StringUtil.nonText(algorithm)) {
            throw new NullPointerException("Missing argument");
        }
        if (key.length == 0) {
            throw new IllegalArgumentException("Empty key");
        }
        if (key.length - off < len) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("len is negative");
        }
        return new SecretKeySpec(key, off, len, algorithm);
    }

    public static PBEKeySpec getPBE(char[] password) {
        return new PBEKeySpec(password);
    }

    public static PBEKeySpec getPBE(char[] password, byte[] salt, int iterationCount, int keyLength) throws NullPointerException, IllegalArgumentException {
        if (ObjectUtil.isNull(password)) {
            throw new NullPointerException("salt missing");
        }
        return new PBEKeySpec(password, salt, iterationCount, keyLength);
    }

    public static PKCS8EncodedKeySpec getPKCS8(byte[] key) throws NullPointerException {
        if (ObjectUtil.isNull(key)) {
            throw new NullPointerException("key missing");
        }
        return new PKCS8EncodedKeySpec(key);
    }

    public static PKCS8EncodedKeySpec getPKCS8(byte[] key, String algorithm) throws NullPointerException, IllegalArgumentException {
        if (ObjectUtil.isNull(key)) {
            throw new NullPointerException("key missing");
        }
        if (StringUtil.nonText(algorithm)) {
            throw new IllegalArgumentException("algorithm missing");
        }
        return new PKCS8EncodedKeySpec(key, algorithm);
    }

    public static X509EncodedKeySpec getX509(byte[] key) throws NullPointerException {
        if (ObjectUtil.isNull(key)) {
            throw new NullPointerException("key missing");
        }
        return new X509EncodedKeySpec(key);
    }

    public static X509EncodedKeySpec getX509(byte[] key, String algorithm) throws NullPointerException, IllegalArgumentException {
        if (ObjectUtil.isNull(key)) {
            throw new NullPointerException("key missing");
        }
        if (StringUtil.nonText(algorithm)) {
            throw new IllegalArgumentException("algorithm missing");
        }
        return new X509EncodedKeySpec(key, algorithm);
    }

    public static PublicKey genPublicKey(KeyFactory keyFactory, X509EncodedKeySpec keySpec) throws InvalidKeySpecException {
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey genPrivateKey(KeyFactory keyFactory, PKCS8EncodedKeySpec keySpec) throws InvalidKeySpecException {
        return keyFactory.generatePrivate(keySpec);
    }

    public static XECPublicKeySpec getXECPub(AlgorithmParameterSpec paramSpec, BigInteger u) {
        return new XECPublicKeySpec(paramSpec, u);
    }
}

