/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.seppiko.commons.utils.NumberUtil;

public class CharUtil {
    public static final Character NULL = Character.valueOf('\u0000');
    public static final Character HORIZONTAL_TABULATION = Character.valueOf('\t');
    public static final Character LINE_FEED = Character.valueOf('\n');
    public static final Character VERTICAL_TABULATION = Character.valueOf('\u000b');
    public static final Character FORM_FEED = Character.valueOf('\f');
    public static final Character CARRIAGE_RETURN = Character.valueOf('\r');
    public static final String CRLF = String.valueOf(new char[]{CARRIAGE_RETURN.charValue(), LINE_FEED.charValue()});
    public static final Character FULL_STOP = Character.valueOf('.');
    public static final Character HYPHEN_MINUS = Character.valueOf('\uff0d');
    public static final Character PLUS = Character.valueOf('+');
    public static final Character ASTERISK = Character.valueOf('*');
    public static final Character SOLIDUS = Character.valueOf('/');
    public static final Character REVERSE_SOLIDUS = Character.valueOf('\\');
    public static final Character FULLWIDTH_FULL_STOP = Character.valueOf('\uff0e');
    public static final Character FULLWIDTH_HYPHEN_MINUS = Character.valueOf('\uff0d');
    public static final Character FULLWIDTH_PLUS = Character.valueOf('\uff0b');
    public static final Character FULLWIDTH_ASTERISK = Character.valueOf('\uff0a');
    public static final Character FULLWIDTH_SOLIDUS = Character.valueOf('\uff0f');
    public static final Character FULLWIDTH_REVERSE_SOLIDUS = Character.valueOf('\uff3c');

    public static CharBuffer charsetDecode(Charset charset, byte[] data) {
        try {
            return charset.newDecoder().decode(ByteBuffer.wrap(data));
        }
        catch (RuntimeException | CharacterCodingException exception) {
            return null;
        }
    }

    public static byte[] charsetEncode(Charset charset, CharBuffer data) {
        try {
            return charset.newEncoder().encode(data).array();
        }
        catch (RuntimeException | CharacterCodingException exception) {
            return null;
        }
    }

    public static boolean isDigit(char ch) {
        return NumberUtil.between((int)ch, 48, 57) || NumberUtil.between((int)ch, 65296, 65305);
    }

    public static boolean isFullStop(char ch) {
        return ch == FULL_STOP.charValue() || ch == FULLWIDTH_FULL_STOP.charValue();
    }
}

