/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.NumberUtil;
import org.seppiko.commons.utils.ObjectUtil;

public class StringUtil {
    private static final Integer BETWEEN = 65248;

    public static CharSequence requireNonBlankElse(CharSequence str, CharSequence defaultStr) {
        return StringUtil.isEmpty(str) ? defaultStr : str;
    }

    public static boolean isEmpty(CharSequence str) {
        return ObjectUtil.isNull(str) || str.length() == 0;
    }

    public static boolean hasLength(CharSequence str) {
        return ObjectUtil.notNull(str) && str.length() > 0;
    }

    public static boolean hasText(CharSequence str) {
        return StringUtil.hasLength(str) && StringUtil.containsText(str);
    }

    public static boolean nonText(CharSequence str) {
        return ObjectUtil.notNull(str) && (str.length() == 0 || !StringUtil.containsText(str));
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch) && Character.isISOControl(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^[-\uff0d]?[0-9\uff10-\uff19]+([\\.\\\uff0e]{1}[0-9\uff10-\uff19]+)?$", input));
    }

    public static boolean isDigit(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^[-\uff0d]?[0-9\uff10-\uff19]+$", input));
    }

    public static boolean isDecimal(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^[-\uff0d]?[0-9\uff10-\uff19]+[\\.\\\uff0e]{1}[0-9\uff10-\uff19]+$", input));
    }

    public static boolean isPunct(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^\\p{Punct}$", input));
    }

    public static boolean isSymbol(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^\\p{Symbol}$", input));
    }

    public static Boolean matches(String regex, CharSequence input) {
        try {
            return Objects.requireNonNull(StringUtil.getMatcher(regex, input)).matches();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Matcher getMatcher(String regex, CharSequence input) {
        try {
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher(input);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public static String transcoding(CharSequence data, Charset oldEncoding, Charset newEncoding) throws NullPointerException {
        return Objects.requireNonNull(CharUtil.charsetDecode(newEncoding, Objects.requireNonNull(CharUtil.charsetEncode(oldEncoding, CharBuffer.wrap(data)), "old encode exception")), "new decode exception").toString();
    }

    public static String fixedLength(String str, int length, char preChar) {
        StringBuilder sb = new StringBuilder();
        if (str.length() < length) {
            int preLength = length - str.length();
            sb.append(String.valueOf(preChar).repeat(preLength));
            sb.append(str);
        } else {
            sb.append(str.substring(str.length() - length));
        }
        return sb.toString();
    }

    public static String toFirstUpperCase(String input) {
        String s = String.valueOf(Character.toUpperCase(input.charAt(0)));
        if (input.length() > 1) {
            return s + input.subSequence(1, input.length());
        }
        return s;
    }

    public static String replaceBetween(CharSequence data, int start, int end, CharSequence replacement) {
        StringBuilder sb = new StringBuilder();
        sb.append(data, 0, start);
        sb.append(replacement);
        sb.append(data, end, data.length());
        return sb.toString();
    }

    public static String convertJoinerString(String delimiter, String ... strs) {
        StringJoiner sj = new StringJoiner(delimiter);
        for (String str : strs) {
            if (!StringUtil.hasLength(str)) continue;
            sj.add(str);
        }
        return sj.toString();
    }

    public static String convertToString(char[] src, int splitNum, String split) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length; i += splitNum) {
            for (int j = 0; j < splitNum; ++j) {
                sb.append(src[i + j]);
            }
            sb.append(split);
        }
        String dst = sb.toString();
        return dst.substring(0, dst.length() - split.length());
    }

    public static char[] convertToCharArray(String src, String split) throws NullPointerException {
        Objects.requireNonNull(src, "src must not be null.");
        Objects.requireNonNull(split, "split must not be null.");
        Matcher m = StringUtil.getMatcher(split, src);
        Objects.requireNonNull(m, "split matcher failed");
        if (m.find()) {
            return m.replaceAll("").toCharArray();
        }
        return src.toCharArray();
    }

    public static String toFullwidth(CharSequence src) {
        CharBuffer cb = CharBuffer.allocate(src.length());
        for (int i = 0; i < cb.length(); ++i) {
            char c = src.charAt(i);
            if (NumberUtil.between((int)c, 32, 126)) {
                cb.append((char)(c + BETWEEN));
                continue;
            }
            cb.append(c);
        }
        return cb.toString();
    }

    public static String toHalfwidth(CharSequence src) {
        CharBuffer cb = CharBuffer.allocate(src.length());
        for (int i = 0; i < cb.length(); ++i) {
            char c = src.charAt(i);
            if (NumberUtil.between((int)c, 65280, 65374)) {
                cb.append((char)(c - BETWEEN));
                continue;
            }
            cb.append(c);
        }
        return cb.toString();
    }

    public static String unicodeDecode(String src) {
        Matcher m = StringUtil.getMatcher("(\\\\u(\\p{XDigit}{4}))", src);
        if (m == null) {
            return src;
        }
        while (m.find()) {
            String group = m.group(2);
            char ch = (char)Integer.parseInt(group, 16);
            String group1 = m.group(1);
            src = src.replace(group1, "" + ch);
        }
        return src;
    }

    public static String unicodeEncode(String src) {
        if (StringUtil.isEmpty(src)) {
            return src;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            if (NumberUtil.between((int)ch, 32, 126)) {
                sb.append(ch);
                continue;
            }
            sb.append("\\u");
            String hex = Integer.toHexString(ch & 0xFFFF).toUpperCase();
            sb.append(StringUtil.fixedLength(hex, 4, '0'));
        }
        return sb.toString();
    }
}

