/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import org.seppiko.commons.utils.MathUtil;
import org.seppiko.commons.utils.NumberUtil;

public class Base62Digit {
    private static final int BASE_COUNT = 62;
    private static final char[] ALPHABET_BASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static String encode(long source) {
        StringBuilder sb = new StringBuilder();
        if (source == 0L) {
            sb.append(ALPHABET_BASE[0]);
        }
        while (source > 0L) {
            long mod = source % 62L;
            sb.append(ALPHABET_BASE[(int)mod]);
            source /= 62L;
        }
        return sb.toString();
    }

    public static long decode(String str) {
        char[] items = str.toCharArray();
        long n = 0L;
        int i = 0;
        int pow = 0;
        while (i < items.length) {
            int m = 0;
            if (NumberUtil.between(items[i], '0', '9')) {
                m = items[i] - 48;
            }
            if (NumberUtil.between(items[i], 'A', 'Z')) {
                m = items[i] - 65 + 10;
            }
            if (NumberUtil.between(items[i], 'a', 'z')) {
                m = items[i] - 97 + 36;
            }
            n += (long)m * MathUtil.power(62, pow).longValue();
            ++i;
            ++pow;
        }
        return n;
    }
}

