/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.AlgorithmParameterGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class GeneratorUtil {
    public static KeyGenerator keyGenerator(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return KeyGenerator.getInstance(algorithm);
    }

    public static KeyGenerator keyGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        return KeyGenerator.getInstance(algorithm, provider);
    }

    public static KeyPairGenerator keyPairGenerator(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return KeyPairGenerator.getInstance(algorithm);
    }

    public static KeyPairGenerator keyPairGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        return KeyPairGenerator.getInstance(algorithm, provider);
    }

    public static AlgorithmParameterGenerator algorithmParameterGenerator(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return AlgorithmParameterGenerator.getInstance(algorithm);
    }

    public static AlgorithmParameterGenerator algorithmParameterGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        return AlgorithmParameterGenerator.getInstance(algorithm, provider);
    }

    public static SecretKey keyGenerator(String algorithm, Provider provider, int keySize) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        KeyGenerator keyGenerator = provider == null ? GeneratorUtil.keyGenerator(algorithm) : GeneratorUtil.keyGenerator(algorithm, provider);
        keyGenerator.init(keySize);
        return keyGenerator.generateKey();
    }

    public static KeyPair keyPairGenerator(String algorithm, Provider provider, int keySize) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        KeyPairGenerator keyPairGenerator = provider == null ? GeneratorUtil.keyPairGenerator(algorithm) : GeneratorUtil.keyPairGenerator(algorithm, provider);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.generateKeyPair();
    }

    public static SecureRandom secureRandom(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return SecureRandom.getInstance(algorithm);
    }

    public static SecureRandom secureRandom(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException {
        return SecureRandom.getInstance(algorithm, provider);
    }

    public static SecureRandom secureRandom(String algorithm, Provider provider, SecureRandomParameters params) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        return SecureRandom.getInstance(algorithm, params, provider);
    }
}

