/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import org.seppiko.commons.utils.StringUtil;

public class NMPUtil
implements Serializable {
    private static final long serialVersionUID = -215141540814890802L;
    private String name;
    private String mode;
    private String padding;

    public NMPUtil(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm.indexOf(47) < 0) {
            this.name = algorithm;
            this.mode = null;
            this.padding = null;
        } else {
            String[] strs = algorithm.split("/");
            if (strs.length == 2) {
                this.name = strs[0];
                this.mode = strs[1];
                this.padding = null;
            } else if (strs.length == 3) {
                this.name = strs[0];
                this.mode = strs[1];
                this.padding = strs[2];
            } else {
                throw new NoSuchAlgorithmException("Algorithm string parser failed.");
            }
        }
    }

    public NMPUtil(String name, String mode, String padding) {
        this.name = name;
        this.mode = mode;
        this.padding = padding;
    }

    public String getName() {
        return this.name;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public String toString() {
        return StringUtil.convertJoinerString("/", this.name, this.mode, this.padding);
    }
}

