/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.seppiko.commons.utils.ObjectUtil;
import org.seppiko.commons.utils.http.HttpClientException;
import org.seppiko.commons.utils.http.HttpClientUtil;
import org.seppiko.commons.utils.http.HttpHeaders;
import org.seppiko.commons.utils.http.HttpMethod;
import org.seppiko.commons.utils.http.HttpResponseException;
import org.seppiko.commons.utils.http.HttpResponseImpl;
import org.seppiko.commons.utils.http.HttpRuntimeException;

public class AsyncHttpClientUtil {
    public static HttpResponse<String> getAsyncResponseString(HttpRequest req, InetSocketAddress proxy) throws HttpRuntimeException, IllegalArgumentException, HttpResponseException {
        try {
            return AsyncHttpClientUtil.httpResponse(AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofString(), proxy));
        }
        catch (IOException e) {
            throw new HttpResponseException(e);
        }
    }

    public static HttpResponse<byte[]> getAsyncResponseByteArray(HttpRequest req, InetSocketAddress proxy) throws HttpRuntimeException, IllegalArgumentException, HttpResponseException {
        try {
            return AsyncHttpClientUtil.httpResponse(AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofByteArray(), proxy));
        }
        catch (IOException e) {
            throw new HttpResponseException(e);
        }
    }

    public static HttpResponse<InputStream> getAsyncResponseInputStream(HttpRequest req, InetSocketAddress proxy) throws HttpRuntimeException, IllegalArgumentException, HttpResponseException {
        try {
            return AsyncHttpClientUtil.httpResponse(AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofInputStream(), proxy));
        }
        catch (IOException e) {
            throw new HttpResponseException(e);
        }
    }

    public static <R, T> HttpResponse<T> sendAsyncRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, R requestBody, Class<T> responseType, InetSocketAddress proxy) throws URISyntaxException, HttpClientException, HttpRuntimeException {
        if (headers == null) {
            headers = HttpHeaders.newHeaders();
        }
        try {
            HttpRequest request = HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderList(), HttpClientUtil.getBodyPublisher(requestBody));
            return AsyncHttpClientUtil.httpResponse(AsyncHttpClientUtil.getAsyncResponseRaw(request, HttpClientUtil.getBodyHandler(responseType), proxy));
        }
        catch (IOException | UnsupportedOperationException ex) {
            throw new HttpClientException(ex.getMessage());
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            throw new HttpRuntimeException(ex);
        }
    }

    private static <T> HttpResponse<T> httpResponse(CompletableFuture<HttpResponse<T>> resp) throws HttpRuntimeException {
        return new HttpResponseImpl<T>(resp);
    }

    private static <T> CompletableFuture<HttpResponse<T>> getAsyncResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, InetSocketAddress proxy) throws IllegalArgumentException, IOException {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (ObjectUtil.notNull(proxy)) {
            builder = builder.proxy(ProxySelector.of(proxy));
        }
        return builder.build().sendAsync(req, responseBodyHandler);
    }
}

