/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import org.seppiko.commons.utils.Assert;
import org.seppiko.commons.utils.StringUtil;

public record HttpCookie(String name, String value) {
    public HttpCookie(String name, String value) {
        Assert.hasLength(name, "'name' is required and must not be empty.");
        this.name = name;
        this.value = value != null ? value : "";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpCookie)) {
            return false;
        }
        HttpCookie otherCookie = (HttpCookie)o;
        return this.name.equalsIgnoreCase(otherCookie.name());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        if (StringUtil.hasLength(this.value)) {
            return this.name + "=" + this.value;
        }
        return this.name;
    }
}

