/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.util.Objects;
import org.seppiko.commons.utils.StringUtil;

public enum HttpMethod {
    GET,
    POST,
    PUT,
    DELETE,
    HEAD,
    OPTIONS,
    CONNECT,
    TRACE,
    PATCH;

    private static final HttpMethod[] VALUES;

    public static HttpMethod resolve(String name) throws NullPointerException {
        Objects.requireNonNull(name, "Method name must not be null");
        String methodname = StringUtil.toHalfwidth(name.strip()).toUpperCase();
        for (HttpMethod method : VALUES) {
            if (!method.name().equals(methodname)) continue;
            return method;
        }
        return null;
    }

    static {
        VALUES = HttpMethod.values();
    }
}

