/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.seppiko.commons.utils.NumberUtil;

public class CharUtil {
    public static final Character NULL = Character.valueOf('\u0000');
    public static final Character HORIZONTAL_TABULATION = Character.valueOf('\t');
    public static final Character LINE_FEED = Character.valueOf('\n');
    public static final Character VERTICAL_TABULATION = Character.valueOf('\u000b');
    public static final Character FORM_FEED = Character.valueOf('\f');
    public static final Character CARRIAGE_RETURN = Character.valueOf('\r');
    public static final String CRLF = String.valueOf(new char[]{CARRIAGE_RETURN.charValue(), LINE_FEED.charValue()});
    public static final Character EXCLAMATION_MARK = Character.valueOf('!');
    public static final Character QUOTATION_MARK = Character.valueOf('\"');
    public static final Character NUMBER_SIGN = Character.valueOf('#');
    public static final Character DOLLAR_SIGN = Character.valueOf('$');
    public static final Character PERCENT_SIGN = Character.valueOf('%');
    public static final Character AMPERSAND = Character.valueOf('&');
    public static final Character APOSTROPHE = Character.valueOf('\'');
    public static final Character LEFT_PARENTHESIS = Character.valueOf('(');
    public static final Character RIGHT_PARENTHESIS = Character.valueOf(')');
    public static final Character ASTERISK = Character.valueOf('*');
    public static final Character PLUS = Character.valueOf('+');
    public static final Character COMMA = Character.valueOf(',');
    public static final Character HYPHEN_MINUS = Character.valueOf('-');
    public static final Character FULL_STOP = Character.valueOf('.');
    public static final Character SOLIDUS = Character.valueOf('/');
    public static final Character COLON = Character.valueOf(':');
    public static final Character SEMICOLON = Character.valueOf(';');
    public static final Character LESS_THAN_SIGN = Character.valueOf('<');
    public static final Character EQUALS_SIGN = Character.valueOf('=');
    public static final Character GREATER_THAN_SIGN = Character.valueOf('>');
    public static final Character QUESTION_MARK = Character.valueOf('?');
    public static final Character COMMERCIAL_AT = Character.valueOf('@');
    public static final Character LEFT_SQUARE_BRACKET = Character.valueOf('[');
    public static final Character REVERSE_SOLIDUS = Character.valueOf('\\');
    public static final Character RIGHT_SQUARE_BRACKET = Character.valueOf(']');
    public static final Character CIRCUMFLEX_ACCENT = Character.valueOf('^');
    public static final Character LOW_LINE = Character.valueOf('_');
    public static final Character GRAVE_ACCENT = Character.valueOf('`');
    public static final Character LEFT_CURLY_BRACKET = Character.valueOf('{');
    public static final Character VERTICAL_LINE = Character.valueOf('|');
    public static final Character RIGHT_CURLY_BRACKET = Character.valueOf('}');
    public static final Character TILDE = Character.valueOf('~');
    public static final Character FULLWIDTH_EXCLAMATION_MARK = Character.valueOf('\uff01');
    public static final Character FULLWIDTH_QUOTATION_MARK = Character.valueOf('\uff02');
    public static final Character FULLWIDTH_NUMBER_SIGN = Character.valueOf('\uff03');
    public static final Character FULLWIDTH_DOLLAR_SIGN = Character.valueOf('\uff04');
    public static final Character FULLWIDTH_PERCENT_SIGN = Character.valueOf('\uff05');
    public static final Character FULLWIDTH_AMPERSAND = Character.valueOf('\uff06');
    public static final Character FULLWIDTH_APOSTROPHE = Character.valueOf('\uff07');
    public static final Character FULLWIDTH_LEFT_PARENTHESIS = Character.valueOf('\uff08');
    public static final Character FULLWIDTH_RIGHT_PARENTHESIS = Character.valueOf('\uff09');
    public static final Character FULLWIDTH_ASTERISK = Character.valueOf('\uff0a');
    public static final Character FULLWIDTH_PLUS = Character.valueOf('\uff0b');
    public static final Character FULLWIDTH_COMMA = Character.valueOf('\uff0c');
    public static final Character FULLWIDTH_HYPHEN_MINUS = Character.valueOf('\uff0d');
    public static final Character FULLWIDTH_FULL_STOP = Character.valueOf('\uff0e');
    public static final Character FULLWIDTH_SOLIDUS = Character.valueOf('\uff0f');
    public static final Character FULLWIDTH_COLON = Character.valueOf('\uff1a');
    public static final Character FULLWIDTH_SEMICOLON = Character.valueOf('\uff1b');
    public static final Character FULLWIDTH_LESS_THAN_SIGN = Character.valueOf('\uff1c');
    public static final Character FULLWIDTH_EQUALS_SIGN = Character.valueOf('\uff1d');
    public static final Character FULLWIDTH_GREATER_THAN_SIGN = Character.valueOf('\uff1e');
    public static final Character FULLWIDTH_QUESTION_MARK = Character.valueOf('\uff1f');
    public static final Character FULLWIDTH_COMMERCIAL_AT = Character.valueOf('\uff20');
    public static final Character FULLWIDTH_LEFT_SQUARE_BRACKET = Character.valueOf('\uff3b');
    public static final Character FULLWIDTH_REVERSE_SOLIDUS = Character.valueOf('\uff3c');
    public static final Character FULLWIDTH_RIGHT_SQUARE_BRACKET = Character.valueOf('\uff3d');
    public static final Character FULLWIDTH_CIRCUMFLEX_ACCENT = Character.valueOf('\uff3e');
    public static final Character FULLWIDTH_LOW_LINE = Character.valueOf('\uff3f');
    public static final Character FULLWIDTH_GRAVE_ACCENT = Character.valueOf('\uff40');
    public static final Character FULLWIDTH_LEFT_CURLY_BRACKET = Character.valueOf('\uff5b');
    public static final Character FULLWIDTH_VERTICAL_LINE = Character.valueOf('\uff5c');
    public static final Character FULLWIDTH_RIGHT_CURLY_BRACKET = Character.valueOf('\uff5d');
    public static final Character FULLWIDTH_TILDE = Character.valueOf('\uff5e');

    public static CharBuffer charsetDecode(Charset charset, byte[] data) {
        try {
            return charset.newDecoder().decode(ByteBuffer.wrap(data));
        }
        catch (RuntimeException | CharacterCodingException exception) {
            return null;
        }
    }

    public static byte[] charsetEncode(Charset charset, CharBuffer data) {
        try {
            return charset.newEncoder().encode(data).array();
        }
        catch (RuntimeException | CharacterCodingException exception) {
            return null;
        }
    }

    public static boolean isDigit(char ch) {
        return NumberUtil.between((int)ch, 48, 57) || NumberUtil.between((int)ch, 65296, 65305);
    }

    public static boolean isFullStop(char ch) {
        return ch == FULL_STOP.charValue() || ch == FULLWIDTH_FULL_STOP.charValue();
    }
}

