/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import org.seppiko.commons.utils.StringUtil;

public class NumberUtil {
    public static final int LATIN_DIGITS = 1;
    public static final int FULLWIDTH_DIGITS = 4;
    private static final int DIGIT_ZERO = 48;
    private static final int DIGIT_NINE = 57;
    private static final int FULLWIDTH_DIGIT_ZERO = 65296;
    private static final int FULLWIDTH_DIGIT_NINE = 65305;

    public static boolean between(byte num, byte min, byte max) {
        return num >= min && num <= max;
    }

    public static boolean between(short num, short min, short max) {
        return num >= min && num <= max;
    }

    public static boolean between(int num, int min, int max) {
        return num >= min && num <= max;
    }

    public static boolean between(long num, long min, long max) {
        return num >= min && num <= max;
    }

    public static boolean between(float num, float min, float max) {
        return num >= min && num <= max;
    }

    public static boolean between(double num, double min, double max) {
        return num >= min && num <= max;
    }

    public static boolean between(char num, char min, char max) {
        return num >= min && num <= max;
    }

    public static boolean between(BigDecimal num, BigDecimal min, BigDecimal max) {
        return num.compareTo(min) >= 0 && num.compareTo(max) <= 0;
    }

    public static boolean between(BigInteger num, BigInteger min, BigInteger max) {
        return num.compareTo(min) >= 0 && num.compareTo(max) <= 0;
    }

    public static String format(String precisionPattern, double number) {
        return new DecimalFormat(precisionPattern).format(number);
    }

    public static int[] toUnsignedIntArray(byte[] src) {
        int[] dst = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Byte.toUnsignedInt(src[i]);
        }
        return dst;
    }

    public static int[] toUnsignedShortArray(short[] src) {
        int[] dst = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Short.toUnsignedInt(src[i]);
        }
        return dst;
    }

    public static long[] toUnsignedLongArray(int[] src) {
        long[] dst = new long[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Integer.toUnsignedLong(src[i]);
        }
        return dst;
    }

    public static String convert(CharSequence input, int outType) throws IllegalArgumentException {
        if (NumberUtil.nonDigit(input)) {
            throw new IllegalArgumentException("input is not number");
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal digit = new BigDecimal(input.toString().replaceAll("\\uFF0B", "+").replaceAll("\\uFF0D", "-").replaceAll("\\uFF0A", "*").replaceAll("\\uFF0F", "/").replaceAll("\\uFF0E", "."));
        if (outType == 1) {
            sb.append(digit);
        } else if (outType == 4) {
            digit.toString().chars().forEach(i -> sb.append((char)(i - 48 + 65296)));
        } else {
            throw new IllegalArgumentException("outType is wrong");
        }
        return sb.toString();
    }

    private static boolean nonDigit(CharSequence input) {
        return !Boolean.TRUE.equals(StringUtil.matches("[-\uff0d+\uff0b]?[0-9\uff10-\uff19]+([\\.\uff0e]{1}[0-9\uff10-\uff19]+)?", input));
    }
}

