/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.StringUtil;

public class HexUtil {
    public static char[] encodeWithBytes(byte[] data) {
        char[] hexs = new char[data.length * 2];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            char[] hex = Integer.toHexString(data[i] & 0xFF).toCharArray();
            if (hex.length == 1) {
                hexs[j] = 48;
                hexs[j + 1] = hex[0];
            } else {
                hexs[j] = hex[0];
                hexs[j + 1] = hex[1];
            }
            ++i;
            j += 2;
        }
        return hexs;
    }

    public static String encodeString(byte[] data) {
        return HexUtil.encodeString(data, " ");
    }

    public static String encodeString(byte[] data, String split) {
        return StringUtil.convertToString(HexUtil.encode(data), 2, split);
    }

    public static char[] encode(byte[] data) {
        return HexUtil.encode(data, true);
    }

    public static char[] encode(byte[] data, boolean toLowerCase) {
        return HexUtil.encode(data, toLowerCase ? Environment.HEXADECIMAL : Environment.HEXADECIMAL_UPPER);
    }

    private static char[] encode(byte[] data, char[] hexChar) {
        char[] hex = new char[data.length * 2];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            byte b = data[i];
            hex[j] = hexChar[(0xF0 & b) >> 4];
            hex[j + 1] = hexChar[0xF & b];
            ++i;
            j += 2;
        }
        return hex;
    }

    public static byte[] decodeString(String data) {
        return HexUtil.decode(data, " ");
    }

    public static byte[] decode(String data, String split) throws IllegalArgumentException, NullPointerException {
        return HexUtil.decode(StringUtil.convertToCharArray(data, split));
    }

    public static byte[] decode(char[] data) throws IllegalArgumentException, NullPointerException {
        if (null == data || data.length == 0) {
            throw new NullPointerException();
        }
        byte[] hex = new byte[data.length / 2];
        int i = 0;
        int j = 0;
        while (i < hex.length) {
            int f = HexUtil.toDigit(data[j]) << 4;
            hex[i] = (byte)((f |= HexUtil.toDigit(data[j + 1])) & 0xFF);
            ++i;
            j += 2;
        }
        return hex;
    }

    private static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit < 0) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }
}

