/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class GeneratorUtil {
    public static KeyGenerator keyGenerator(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return KeyGenerator.getInstance(algorithm);
    }

    public static KeyGenerator keyGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        return KeyGenerator.getInstance(algorithm, provider);
    }

    private static KeyGenerator keyGenerator0(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        if (provider == null) {
            return GeneratorUtil.keyGenerator(algorithm);
        }
        return GeneratorUtil.keyGenerator(algorithm, provider);
    }

    public static KeyPairGenerator keyPairGenerator(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return KeyPairGenerator.getInstance(algorithm);
    }

    public static KeyPairGenerator keyPairGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        return KeyPairGenerator.getInstance(algorithm, provider);
    }

    private static KeyPairGenerator keyPairGenerator0(String algorithm, Provider provider) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        if (provider == null) {
            return GeneratorUtil.keyPairGenerator(algorithm);
        }
        return GeneratorUtil.keyPairGenerator(algorithm, provider);
    }

    public static AlgorithmParameterGenerator algorithmParameterGenerator(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return AlgorithmParameterGenerator.getInstance(algorithm);
    }

    public static AlgorithmParameterGenerator algorithmParameterGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        return AlgorithmParameterGenerator.getInstance(algorithm, provider);
    }

    public static SecretKey keyGenerator(String algorithm, Provider provider, int keySize) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        KeyGenerator keyGenerator = GeneratorUtil.keyGenerator0(algorithm, provider);
        keyGenerator.init(keySize);
        return keyGenerator.generateKey();
    }

    public static KeyPair keyPairGenerator(String algorithm, Provider provider, int keySize) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException {
        KeyPairGenerator keyPairGenerator = GeneratorUtil.keyPairGenerator0(algorithm, provider);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.generateKeyPair();
    }

    public static KeyPair keyPairGenerator(String algorithm, Provider provider, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, IllegalArgumentException, NullPointerException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = GeneratorUtil.keyPairGenerator0(algorithm, provider);
        keyPairGenerator.initialize(params);
        return keyPairGenerator.generateKeyPair();
    }

    public static SecureRandom secureRandom(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return SecureRandom.getInstance(algorithm);
    }

    public static SecureRandom secureRandom(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException {
        return SecureRandom.getInstance(algorithm, provider);
    }

    public static SecureRandom secureRandom(String algorithm, Provider provider, SecureRandomParameters params) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        return SecureRandom.getInstance(algorithm, params, provider);
    }

    private static SecureRandom secureRandom0(String algorithm, Provider provider, SecureRandomParameters params) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        if (provider == null && params == null) {
            return GeneratorUtil.secureRandom(algorithm);
        }
        if (params == null) {
            return GeneratorUtil.secureRandom(algorithm, provider);
        }
        return GeneratorUtil.secureRandom(algorithm, provider, params);
    }
}

