/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.seppiko.commons.utils.crypto.CryptoUtil;
import org.seppiko.commons.utils.crypto.Cryptography;
import org.seppiko.commons.utils.crypto.NMPUtil;

public class SymmetricUtil
implements Cryptography,
Serializable {
    private static final long serialVersionUID = 3727544559578025620L;
    private final NMPUtil algorithm;
    private Provider provider = CryptoUtil.NONPROVIDER;
    private Key key;
    private AlgorithmParameterSpec params = null;

    public SymmetricUtil(String algorithm) throws NoSuchAlgorithmException {
        this.algorithm = new NMPUtil(algorithm);
    }

    @Override
    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    @Override
    public void setParameterSpec(AlgorithmParameterSpec params) {
        this.params = params;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    @Override
    public byte[] encrypt(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, NullPointerException {
        Objects.requireNonNull(this.key);
        return CryptoUtil.cipher(this.algorithm.toString(), this.provider, 1, this.key, this.params, data);
    }

    @Override
    public byte[] decrypt(byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException, NullPointerException {
        Objects.requireNonNull(this.key);
        return CryptoUtil.cipher(this.algorithm.toString(), this.provider, 2, this.key, this.params, data);
    }
}

