/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class ParamterSpacUtil {
    public static GCMParameterSpec getGCM(int tLen, byte[] src) throws NullPointerException, IllegalArgumentException {
        if (src == null) {
            throw new NullPointerException("src missing");
        }
        return ParamterSpacUtil.getGCM(tLen, src, 0, src.length);
    }

    public static GCMParameterSpec getGCM(int tLen, byte[] src, int off, int len) throws IllegalArgumentException {
        return new GCMParameterSpec(tLen, src, off, len);
    }

    public static IvParameterSpec getIV(byte[] iv) throws NullPointerException {
        if (iv == null) {
            throw new NullPointerException("IV missing");
        }
        return ParamterSpacUtil.getIV(iv, 0, iv.length);
    }

    public static IvParameterSpec getIV(byte[] iv, int off, int len) {
        return new IvParameterSpec(iv, off, len);
    }

    public static PBEParameterSpec getPBE(byte[] salt, int iterationCount) throws NullPointerException {
        return ParamterSpacUtil.getPBE(salt, iterationCount, null);
    }

    public static PBEParameterSpec getPBE(byte[] salt, int iterationCount, AlgorithmParameterSpec paramSpec) throws NullPointerException {
        if (salt == null) {
            throw new NullPointerException("IV missing");
        }
        return new PBEParameterSpec(salt, iterationCount, paramSpec);
    }

    public static DHParameterSpec getDH(BigInteger p, BigInteger g) {
        return ParamterSpacUtil.getDH(p, g, 0);
    }

    public static DHParameterSpec getDH(BigInteger p, BigInteger g, int l) {
        return new DHParameterSpec(p, g, l);
    }

    public static ECParameterSpec getEC(ECField field, BigInteger fristCoefficient, BigInteger secondfficient, BigInteger affineX, BigInteger affineY, BigInteger generator, int cofactor) throws NullPointerException, IllegalArgumentException {
        EllipticCurve curve = new EllipticCurve(field, fristCoefficient, secondfficient);
        ECPoint point = new ECPoint(affineX, affineY);
        return new ECParameterSpec(curve, point, generator, cofactor);
    }
}

