/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.util.Objects;

public enum HttpMethod {
    GET,
    POST,
    PUT,
    DELETE,
    HEAD,
    OPTIONS,
    CONNECT,
    TRACE,
    PATCH;

    private static final HttpMethod[] VALUES;

    public static HttpMethod resolve(String name) throws NullPointerException {
        Objects.requireNonNull(name);
        String methodName = name.strip().toUpperCase();
        for (HttpMethod method : VALUES) {
            if (!method.name().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    static {
        VALUES = HttpMethod.values();
    }
}

