/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.net.URI;
import java.util.Objects;
import org.seppiko.commons.utils.CharUtil;

public class URIUtil {
    public static URI getUri(String uri) throws NullPointerException, IllegalArgumentException {
        return URI.create(uri);
    }

    public static String getLastPathname(String uri) throws IllegalArgumentException, NullPointerException {
        String filename = URIUtil.getUri(uri).getPath();
        return filename.substring(filename.lastIndexOf(CharUtil.SOLIDUS.charValue()) + 1);
    }

    public static String getFileExtension(String filename) throws NullPointerException {
        Objects.requireNonNull(filename);
        if (filename.lastIndexOf(CharUtil.FULL_STOP.charValue()) >= 0 && filename.matches("\\p{Alnum}+$")) {
            return filename.substring(filename.lastIndexOf(CharUtil.FULL_STOP.charValue()) + 1).toLowerCase();
        }
        return null;
    }
}

