/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.seppiko.commons.utils.reflect.ReflectionUtil;

public class ResultUtil {
    public static ArrayList<HashMap<String, Object>> convert(ResultSet resultSet) throws SQLException {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        ResultSetMetaData row = resultSet.getMetaData();
        int colSize = row.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (int i = 0; i < colSize; ++i) {
                rowMap.put(row.getColumnName(i), resultSet.getObject(i));
            }
            result.add(rowMap);
        }
        resultSet.close();
        return result;
    }

    public static <T> ArrayList<T> convert(ResultSet resultSet, Class<T> clazz) throws SQLException, IllegalAccessException {
        ArrayList<T> result = new ArrayList<T>();
        ResultSetMetaData row = resultSet.getMetaData();
        int colSize = row.getColumnCount();
        while (resultSet.next()) {
            T t;
            Field[] fields;
            try {
                fields = ReflectionUtil.getDeclaredFields(clazz);
            }
            catch (SecurityException e) {
                try {
                    fields = ReflectionUtil.getRecordFields(clazz);
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    throw new IllegalAccessException("Failed to get record class field.");
                }
            }
            Class[] paramTypes = new Class[fields.length];
            Object[] args = new Object[fields.length];
            int i = 0;
            int j = 1;
            while (i < colSize) {
                fields[i].setAccessible(true);
                paramTypes[i] = fields[i].getType();
                args[i] = resultSet.getObject(j);
                ++i;
                ++j;
            }
            try {
                t = ReflectionUtil.setRecordAllFields(clazz, paramTypes, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                try {
                    t = ReflectionUtil.newInstance(clazz);
                }
                catch (InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new IllegalAccessException("Call parameterless constructor failed.");
                }
                for (Field field : fields) {
                    ReflectionUtil.setField(field, t, field.get(t));
                }
            }
            result.add(t);
        }
        resultSet.close();
        return result;
    }
}

