/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.seppiko.commons.utils.ObjectUtil;

public class SqlTypeUtil {
    public static LocalDateTime convertSqlDateTime(Date date, Time time) {
        return date.toLocalDate().atTime(time.toLocalTime());
    }

    public static LocalDateTime convertSqlTimestamp(Timestamp timestamp) {
        return timestamp.toLocalDateTime();
    }

    public static <T> T convertTypeObject(Object sqlObj, Class<T> type) throws NullPointerException, IllegalArgumentException {
        if (ObjectUtil.isNull(sqlObj)) {
            throw new NullPointerException();
        }
        if (sqlObj.getClass().equals(type)) {
            return (T)sqlObj;
        }
        throw new IllegalArgumentException();
    }
}

