/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CollectionUtil {
    public static <K, V> Map<K, V> populateMap(Collection<? extends V> elements, Function<? super V, ? extends K> keyFunction) {
        return CollectionUtil.populateMap(elements, keyFunction, Function.identity());
    }

    public static <K, V, E> Map<K, V> populateMap(Collection<? extends E> elements, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> valueFunction) {
        return elements.stream().collect(Collectors.toMap(keyFunction, valueFunction, (key1, key2) -> key2));
    }

    public static <K, V, E> Map<K, V> populateMapWithoutFilter(Collection<? extends E> elements, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> valueFunction) throws IllegalStateException {
        return elements.stream().collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static <T, E> List<T> populateList(Collection<? extends E> elements, Function<? super E, ? extends T> valueFunction) {
        return elements.stream().map(valueFunction).collect(Collectors.toList());
    }

    public static <T, C extends Collection<T>> Collection<T> clone(Collection<? extends T> collection, Supplier<C> supplier) {
        return (Collection)collection.stream().collect(Collectors.toCollection(supplier));
    }
}

