/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.StringUtil;

public class MathUtil {
    public static BigDecimal maxDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).max(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigInteger maxInteger(List<BigInteger> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).max(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigDecimal minDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).min(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigInteger minInteger(List<BigInteger> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).min(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigDecimal avgDecimal(List<BigDecimal> nums, RoundingMode roundingMode) {
        return nums.stream().map(Objects::requireNonNull).reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(nums.size()), roundingMode);
    }

    public static double avgDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().mapToDouble(BigDecimal::doubleValue).average().orElseThrow();
    }

    public static BigDecimal avgInteger(List<BigInteger> nums, RoundingMode roundingMode) {
        BigInteger sum = nums.stream().map(Objects::requireNonNull).reduce(BigInteger.ZERO, BigInteger::add);
        return new BigDecimal(sum).divide(BigDecimal.valueOf(nums.size()), roundingMode);
    }

    public static BigInteger power(int a, int b) {
        return MathUtil.power(new BigInteger(String.valueOf(a)), b);
    }

    public static BigInteger power(long a, int b) {
        return MathUtil.power(new BigInteger(String.valueOf(a), 19), b);
    }

    public static BigInteger power(BigInteger a, int b) {
        return a.pow(b);
    }

    public static BigDecimal power(double a, int b) {
        return MathUtil.power(new BigDecimal(a), b);
    }

    public static BigDecimal power(BigDecimal a, int b) {
        return a.pow(b);
    }

    public static String convertDecimalTo(long num, char[] alphabet) {
        if (num < 1L) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        int length = alphabet.length;
        long n = num;
        while (n > 0L) {
            long m = n % (long)length;
            if (m == 0L) {
                m = length;
            }
            s.insert(0, alphabet[(int)(m - 1L)]);
            n = (n - m) / (long)length;
        }
        return s.toString();
    }

    public static Long convertToDecimal(CharSequence num, char[] alphabet) {
        if (!StringUtil.hasText(num)) {
            return null;
        }
        long n = 0L;
        int l = alphabet.length;
        int nl = num.length();
        for (int i = 0; i < nl; ++i) {
            int index = CharUtil.findIndex(num.charAt(i), alphabet) + 1;
            int last = nl - i - 1;
            n += BigInteger.valueOf(l).pow(last).multiply(BigInteger.valueOf(index)).longValue();
        }
        return n;
    }
}

